local PANEL	= {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// init
function PANEL:Init( )
	// linked class
	self.LinkedClass = nil;
	
	// die?
	self.DieAt = -1;	

	// chidlren
	self.Children = {};
	
	// submenu architecture.
	self.ParentMenu = nil;
	self.ChildMenu = nil;
	
	// image list
	self.ImageList = nil;
	
	// set zpos
	self:SetZPos( 5000 );
	self:SetSize( 196, 196 );
	
end

// mouse entered/exited
function PANEL:OnCursorEntered( )
	// don't die
	self.DieAt = -1;

end
function PANEL:OnCursorExited( )
	// die 0.1 seconds after we leave
	self.DieAt = CurTime() + 0.5;

end

// set image list
function PANEL:SetImageList( list )
	self.ImageList = list;
	
end

// collapse all
function PANEL:CollapseAll( )
	// collapse every child menu
	if( self.ChildMenu ) then
		self.ChildMenu:SetVisible( false );
		self.ChildMenu.ParentMenu = nil;
		self.ChildMenu:CollapseAll();
		
	end
	
	// nil out our child menu
	self.ChildMenu = nil;
	
end

// events
function PANEL:ShowSubMenu( item, menu )
	// collapse everything we already have out.
	self:CollapseAll();

	// store menu as our child.
	self.ChildMenu = menu:GetHandle();
	menu:GetHandle().ParentMenu = self;
	
	// position it.
	local x, y = item:GetPos();
	local mx, my = self:GetPos();
	local mw, mh = self.ChildMenu:GetSize();
	
	// calculate new menu position.
	x = math.Clamp( mx + self:GetWide(), 0, ScrW() - mw );
	y = math.Clamp( y + my, 0, ScrH() - mh );

	// set it's position.
	self.ChildMenu:SetPos( x, y );
	self.ChildMenu:SetVisible( true );
	
	// this here? why? might be just cause I'm tired and have no idea what i"m typing.
	// oh shit.. how long has it been.
	// err 19hrs >_>.... well guess it's gonna be 28hrs before I go to bed... another 9 hours left.
	// oh shit i'm going to shutup now.
	self.ChildMenu.DieAt = -1;
	
end

// events
function PANEL:HideSubMenu( )
	self:CollapseAll();
	
end



// think
function PANEL:Think( )
	// should we die?
	if( self:IsVisible() && self.DieAt != -1 && self.DieAt <= CurTime() && !self.ChildMenu ) then
		// reset die at.
		self.DieAt = -1;		// again tired.. this entire menu has been written under the influence of lack of sleep.
	
		// we have a parent?
		if( self.ParentMenu ) then
			// collapse it.
			self.ParentMenu:CollapseAll();
		
		else
			// simply hide.
			self:SetVisible( false );
			
		end
	
	end

end

// perform layout
function PANEL:PerformLayout( )
	// setup children.
	local ofs, child = 4;
	for _, child in pairs( self.Children ) do
		// setup the item.
		child:SetPos( 4, ofs );
		
		// calculate size.
		if( child.Seperator ) then
			child:SetSize( self:GetWide() - 8, 8 );
			
		else
			child:SetSize( self:GetWide() - 8, 16 );
			
		end
		
		// increment
		ofs = ofs + child:GetTall();
	
	end

	// size myself.
	self:SetSize( self:GetWide(), ofs + 4 );
	
end

// item click.
function PANEL:DoItemClick( item )
	// we have a parent?
	if( self.ParentMenu ) then
		// pass along
		self.ParentMenu:DoItemClick( item );

	// call event.
	else
		// event.
		if( self.LinkedClass ) then
			self.LinkedClass:CallEvent( "OnContextItemClick", item );
		
		end
		
		// collapse everything including myself.
		self:CollapseAll();
		
		// hide.
		self:SetVisible( false );
		
	end
	
end

// paint
function PANEL:Paint( )
	// fetch colors
	local fgcolor = AppFramework:Theme().colors['window_face_sub'];
	local bgcolor = AppFramework:Theme().colors['border_dark'];
	
	// width/height
	local width, height = self:GetSize();

	// background.
	surface.SetDrawColor(
		bgcolor.r,
		bgcolor.g,
		bgcolor.b,
		bgcolor.a
	);
	surface.DrawRect(
		0, 0,
		width, height
	);
	
	// foreground.
	surface.SetDrawColor(
		fgcolor.r,
		fgcolor.g,
		fgcolor.b,
		fgcolor.a
	);
	surface.DrawRect(
		1, 1,
		width - 2, height - 2
	);
	
	// color.
	local color = AppFramework:Theme().colors['selection'];
	
	// draw icon tray.
	draw.NoTexture();
	surface.SetDrawColor(
		color.r,
		color.g,
		color.b,
		color.a
	);
	surface.DrawRect(
		1, 1,
		24, height - 2
	);
	

	//
	return true;
	
end

// add item
function PANEL:CreateItem( )
	// create item.
	local item = vgui.Create( "ctl_contextmenuitem", self );
	
	// add to children
	table.insert( self.Children, item );
	
	// invalidate.
	self:InvalidateLayout();
	
	//
	return item;

end

// popup
function PANEL:Popup( )
	// set pos
	self:SetPos( gui.MouseX(), gui.MouseY() );
	self:SetVisible( true );
	
	// 26hrs... T_T
	self.DieAt = -1;
	
	// invalidate
	self:InvalidateLayout();

end


// register it.
vgui.Register( "ctl_contextmenu", PANEL, "Panel" );

 

// create app framework control.
CtlContextMenu_class 	= Control_class:create( nil, false, "ctl_contextmenu" );

// set imagelist.
function CtlContextMenu_class:SetImageList( list )
	self:GetHandle():SetImageList( list );
	
end

// create item.
function CtlContextMenu_class:DoItemClick( item )
	return self:GetHandle():DoItemClick( item );

end

// create item.
function CtlContextMenu_class:CreateItem( )
	return self:GetHandle():CreateItem();

end

// popup
function CtlContextMenu_class:Popup( )
	self:GetHandle():Popup();

end
